﻿//
// $safeitemname$.xaml.cpp
// $safeitemname$ 类的实现
//

#include "pch.h"
#include "$safeitemname$.xaml.h"

using namespace $rootnamespace$;
using namespace $safeprojectname$::Common;

using namespace Platform;
using namespace Windows::Foundation;
using namespace Windows::Foundation::Collections;
using namespace Windows::UI::ViewManagement;
using namespace Windows::UI::Xaml;
using namespace Windows::UI::Xaml::Controls;
using namespace Windows::UI::Xaml::Controls::Primitives;
using namespace Windows::UI::Xaml::Data;
using namespace Windows::UI::Xaml::Input;
using namespace Windows::UI::Xaml::Media;
using namespace Windows::UI::Xaml::Navigation;

// “拆分页”项模板在 http://go.microsoft.com/fwlink/?LinkId=234234 上提供

$safeitemname$::$safeitemname$()
{
	InitializeComponent();
}

#pragma region Page state management

/// <summary>
/// 使用在导航过程中传递的内容填充页。在从以前的会话
/// 重新创建页时，也会提供任何已保存状态。
/// </summary>
/// <param name="navigationParameter">最初请求此页时传递给
/// <see cref="Frame::Navigate(Type, Object)"/> 的参数值。
/// </param>
/// <param name="pageState">此页面在之前的会话期间保留的状态
/// 字典。首次访问页面时为 null。</param>
void $safeitemname$::LoadState(Object^ navigationParameter, IMap<String^, Object^>^ pageState)
{
	// TODO: 使用 DefaultViewModel->Insert("Group", <value>) 设置可绑定组
	// TODO: 使用 DefaultViewModel->Insert("Items", <value>) 设置可绑定项集合

	if (pageState == nullptr)
	{
		// 当这是新页时，除非正在使用逻辑页导航，
		// 否则会自动选择第一项(请参见下面的逻辑页导航 #region。)
		if (!UsingLogicalPageNavigation() && itemsViewSource->View != nullptr)
		{
			itemsViewSource->View->MoveCurrentToFirst();
		}
	}
	else
	{
		// 还原与此页关联的以前保存的状态
		if (pageState->HasKey("SelectedItem") && itemsViewSource->View != nullptr)
		{
			// TODO: 使用选定项调用 itemsViewSource->View->MoveCurrentTo()，
			//       该选定项由值 pageState->Lookup("SelectedItem")指定
		}
	}
}

/// <summary>
/// 保留与此页关联的状态，以防挂起应用程序或
/// 从导航缓存中放弃此页。值必须符合
/// <see cref="SuspensionManager::SessionState"/> 的序列化要求。
/// </summary>
/// <param name="pageState">要使用可序列化状态填充的空映射。</param>
void $safeitemname$::SaveState(IMap<String^, Object^>^ pageState)
{
	if (itemsViewSource->View != nullptr)
	{
		auto selectedItem = itemsViewSource->View->CurrentItem;
		// TODO: 派生一个可序列化的导航参数，并将其传递给
		//       pageState->Insert("SelectedItem", <value>)
	}
}

#pragma endregion

#pragma region Logical page navigation

// 视觉状态管理通常直接反映四种应用程序视图状态(全
// 屏横向与纵向以及对齐和填充视图。)设计拆分页的目的在于使
// 对齐和纵向视图状态均有两个不同的子状态: 显示
// 项列表或详细信息之一，但不同时显示。
//
// 这完全通过一个可表示两个逻辑页的单一物理页实现。
// 使用下面的代码可以实现此目标，且用户不会察觉到区别。

/// <summary>
/// 在确定该页是应用作一个逻辑页还是两个逻辑页时进行调用。
/// </summary>
/// <returns>当前视图状态为纵向或对齐时为 true，否则为 false
/// 。</returns>
bool $safeitemname$::UsingLogicalPageNavigation()
{
	return UsingLogicalPageNavigation(ApplicationView::Value);
}

/// <summary>
/// 在确定该页是应用作一个逻辑页还是两个逻辑页时进行调用。
/// </summary>
/// <param name="viewState">提出的问题所针对的视图状态。</param>
/// <returns>当所涉及的视图状态为纵向或对齐时，此项为 true，否则为 false
/// 。</returns>
bool $safeitemname$::UsingLogicalPageNavigation(ApplicationViewState viewState)
{
	return viewState == ApplicationViewState::FullScreenPortrait ||
		viewState == ApplicationViewState::Snapped;
}

/// <summary>
/// 在选定列表中的项时进行调用。
/// </summary>
/// <param name="sender">显示所选项的 GridView (在应用程序处于对齐状态时
/// 为 ListView)。</param>
/// <param name="e">描述如何更改选择内容的事件数据。</param>
void $safeitemname$::ItemListView_SelectionChanged(Object^ sender, SelectionChangedEventArgs^ e)
{
	(void) sender;	// 未使用的参数
	(void) e;	// 未使用的参数

	// 在逻辑页导航起作用时使视图状态无效，因为
	// 更改所选内容可能会导致当前逻辑页发生相应的更改。 选择某项后
	// 其效果是将显示项列表变为显示
	// 所选项的详细信息。 清除所选内容后，这将产生相反的效果。
	if (UsingLogicalPageNavigation()) InvalidateVisualState();
}

/// <summary>
/// 在按页上的后退按钮时调用。
/// </summary>
/// <param name="sender">后退按钮实例。</param>
/// <param name="e">描述如何单击后退按钮的事件数据。</param>
void $safeitemname$::GoBack(Object^ sender, RoutedEventArgs^ e)
{
	if (UsingLogicalPageNavigation() && itemListView->SelectedItem != nullptr)
	{
		// 当逻辑页导航起作用且选择了某项时，当前将显示
		// 该项的详细信息。 清除所选内容将返回项列表。
		// 从用户的角度来看，这在逻辑上是向后导航。
		itemListView->SelectedItem = nullptr;
	}
	else
	{
		// 当逻辑页导航无效或未选择任何项时，使用
		// 默认的后退按钮行为。
		LayoutAwarePage::GoBack(sender, e);
	}
}

/// <summary>
/// 调用以判断对应于应用程序视图状态的可视状态的名称
/// 的名称。
/// </summary>
/// <param name="viewState">提出的问题所针对的视图状态。</param>
/// <returns>所需可视状态的名称。 此名称与视图状态的名称相同，
/// 但在通过添加 _Detail 后缀表示此附加逻辑页的纵向和对齐视图中
/// 选择了某项后例外。</returns>
String^ $safeitemname$::DetermineVisualState(ApplicationViewState viewState)
{
	// 在视图状态更改时更新后退按钮的启用状态
	auto logicalPageBack = UsingLogicalPageNavigation(viewState) && itemListView->SelectedItem != nullptr;
	auto physicalPageBack = Frame != nullptr && Frame->CanGoBack;
	DefaultViewModel->Insert("CanGoBack", logicalPageBack || physicalPageBack);

	// 决定横向布局可视状态的依据不是视图状态，而是
	// 窗口的宽度。 此页面有一个布局适合
	// 1366 个虚拟像素或更宽，还具有一个布局适合较窄的显示屏或应用程序
	// 应用程序对齐后可用水平空间减小到小于 1366 的情况。
	if (viewState == ApplicationViewState::Filled ||
		viewState == ApplicationViewState::FullScreenLandscape)
	{
		auto windowWidth = Window::Current->Bounds.Width;
		if (windowWidth >= 1366) return "FullScreenLandscapeOrWide";
		return "FilledOrNarrow";
	}

	// 在纵向或对齐视图中开头是默认可视状态名称，然后在查看详细信息(而不是列表)
	// 时添加后缀
	String^ defaultStateName = LayoutAwarePage::DetermineVisualState(viewState);
	return logicalPageBack ? defaultStateName + "_Detail" : defaultStateName;
}
#pragma endregion
